﻿using System.Collections;
using System.Collections.Generic;
using UnityEngine;
using UnityEngine.AddressableAssets;

public class DestroyAddressable : MonoBehaviour
{
    private void Start()
    {
        StartCoroutine(TimedDestroy());
    }

    private IEnumerator TimedDestroy()
    {
        yield return new WaitForSeconds(2.0f);
        Addressables.ReleaseInstance(gameObject);
        Destroy(gameObject);
    }
}
